<?php
/**
 * @package 	OT Brand Map Module for Joomla! 3.3
 * @version 	$Id: helper.php - Mar 2015 00:00:00Z OmegaTheme
 * @author 		OmegaTheme Extensions (services@omegatheme.com) - http://omegatheme.com
 * @copyright	Copyright(C) 2015 - OmegaTheme Extensions
 * @license 	http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
**/
 
// no direct access
defined('_JEXEC') or die('Restricteted access');
/**
 * modOtMapsHelper class to initialise the database for the Module OT Brand Maps.
 *
 * @package     Module OT Brand Maps
 * @subpackage  modOtMapsHelper
 * @since       3.1
 */
 include 'elements/SimpleImage.php';
abstract class modOtMapsHelper
{
	 /**
     * The generated getMaps
     *
     * @var    string
     * @since  3.1
     */
    public static function getMaps(&$params)
    {
		$url=Juri::root();
		$img = new SimpleImage();
		$mapsarray = array();
        $maps = $params->get('otmaps');
		$type_resize= $params->get('type_resize','crop');
		$width_resize=$params->get('width_resize',100);
		$height_resize=$params->get('height_resize',100);
        if (!is_array($maps) || empty($maps))
		{
			return array();
        }
        foreach ($maps as $idx => $map)
        {
            $item = array();              
            $item[0]= $map->lat;
			$item[8]= $map->lng;
			$item[9]= $map->icon;
			$item[10]= $map->image;
			if(!empty($map->image)) {
			@$image1 =end(explode("/",$item[10]));
			@$image2= current(explode(".",$image1));
			@$image3= end(explode(".",$image1));
			$ot_image='modules/mod_otbrandmaps/assets/images/resize/'.$image2.'_'.$type_resize.'_'.$width_resize.'x'.$height_resize.'.'.$image3.'';
			if(file_exists($ot_image)) {			
			} else {
			$img->resize_image($type_resize,$item[10],$ot_image,$width_resize,$height_resize);
			}
			$item[10]=$url.''.$ot_image;
			} 
            $item[1]= $map->name; 
            $item[2]= $map->address; 
			$item[3]=$map->phone;
			$item[4]=$map->web;
			$item[5]=$map->email;
			$item[6]=$map->fax;
			$item[7]=$map->area;
            $mapsarray[] = $item;	
        }           
        return $mapsarray;
    }
}
